
/*
 * DictionaryMultiServer.java
 *
 * Created on October 26, 2004, 1:32 PM
 */
package tcp;

import java.net.*;
import java.io.*;
import java.util.*;

/**
 *
 * @author  garbi
 */
public class ManagedDictionaryMultiServer {
    private static final int READER_PORT= 4443; //for client
    private static final int MANAGER_PORT= 4449;//for manager
    private static Map dico= Collections.synchronizedMap(new Hashtable());

    public static void main(String[] args) {
        try {
            
            final ServerSocket connectionServer= new ServerSocket(READER_PORT);
            
            final ServerSocket managerServer= new ServerSocket(MANAGER_PORT);
            

            Thread readerAcceptor= new Thread() {
                public void run() {

                    try {
                        while (true) {
                            Socket readerSession = connectionServer.accept();
                            new ReaderSessionThread(readerSession, dico).start();
                        }
                    } catch (IOException e) {
                        System.out.println(e); System.exit(1);
                    }
                }
            };

            Thread managerAcceptor= new Thread() {
                public void run() {

                    try {
                        while (true) {
                            Socket managerSession = managerServer.accept();
                            new ManagerSessionThread(managerSession,dico).start();
                        }
                    } catch (IOException e) {
                        System.out.println(e); System.exit(1);
                    }
                }
            };
            managerAcceptor.start();
            readerAcceptor.start();

        } catch (IOException e) {
            System.out.println(e); System.exit(1);
        }
    }
}

class ReaderSessionThread extends Thread {
    Socket readerSession;
    Map dico;
    ReaderSessionThread(Socket readerSession, Map dico) {
        this.readerSession= readerSession;
        this.dico= dico;
    }

    public void run() {
        try {
            PrintWriter out= new PrintWriter(readerSession.getOutputStream(), true);
            BufferedReader in= new BufferedReader(new InputStreamReader(readerSession.getInputStream()));
            String word, mot;

            System.out.println("New reader session opened.");
            while ( (word = in.readLine()) != null ) {
                mot= (String) dico.get(word);
                if (mot == null) mot= "sorry, no translation available for \"" + word + "\" !";
                out.println(mot);
            }
            out.close();
            in.close();
            readerSession.close();
            System.out.println("Reader session closed.");
        } catch (IOException e) {
            System.out.println(e);
        }
    }
}

class ManagerSessionThread extends Thread {
    Socket managerSession;
    Map dico;
    ManagerSessionThread(Socket managerSession, Map dico) {
        this.managerSession= managerSession;
        this.dico= dico;
    }

    public void run() {
        try {
            PrintWriter out= new PrintWriter(managerSession.getOutputStream(), true);
            ObjectInputStream in= new ObjectInputStream(managerSession.getInputStream());
            Object input; String feedback;

            System.out.println("New manager session opened.");
            while ( (input= in.readObject()) != null ) {
                try {
                    String[] entry= (String[]) input;
                    dico.put(entry[0], entry[1]);
                    feedback= "New entry inserted: " + entry[0] + " = " + entry[1];
                } catch (Exception e) {
                    feedback= "Entry no inserted: " + e.getMessage();
                }
                System.out.println(feedback);
                out.println(feedback);
            }
            out.close();
            in.close();
            managerSession.close();
            System.out.println("Manager session closed.");
        } catch (Exception e) {
            System.out.println(e);
        }
    }
}
